 function x = logit_s_to_x(s,i_base)
  % s is a T x n matrix with each row a vector of shares (so they add to 1)
  % i_base is the base sector
  s_base = s(:,i_base);
  if min(s_base) < 0.00001
    error('base sector tiny share');
  end
  % Make sure shares are positive
  tmp = s < 0.0001;
  s(tmp==1) = 0.0001;
  tmp = s./repmat(s_base,1,size(s,2));
  x = log(tmp);
end